<?php
declare(strict_types=1);

/**
 * DigitalVirtual OTP Receiver (PHP, single file)
 * - Login (session-based) + CSRF
 * - Mobile-first UI, responsif & user-friendly
 * - Beli nomor & tampilkan SMS OTP (poll /v1/user/check/{id})
 * - Saldo (GET /v1/user/vendor)
 * - Harga nomor (response price/cost atau delta saldo)
 * - Copy nomor TANPA kode negara & Copy OTP
 * - Notifikasi & bunyi bel saat beli nomor / SMS / OTP
 *
 * Prasyarat: PHP 7.4+ (ext-curl), session aktif
 */

session_start();

// ---------- Konfigurasi ----------
$APP_USER = getenv('APP_USER') ?: 'admin';
$APP_PASS = getenv('APP_PASS') ?: 'admin'; // ganti di environment untuk produksi

$TOKEN = getenv('FIVESIM_TOKEN') ?: 'eyJhbGciOiJSUzUxMiIsInR5cCI6IkpXVCJ9.eyJleHAiOjE3ODc0NDkwMTksImlhdCI6MTc1NTkxMzAxOSwicmF5IjoiNWQ4YzgxNDQ2NDYwYjk4YzY5NGNhMGNiODZkN2JkZjQiLCJzdWIiOjI4MjM1Njl9.Gy-ZxatKUsIHFqa4KZMRNpYP-RZRn3GcZXYqMf6gUAM9NitrEqmdDmGETwDlW4QKxTCbQDmbOKD6ltAjKvBTOWA1Y03runSaLguVoP0kOoqgq2ye5LHlvO8x00lyteZsn-n4NMvAXjPjIGfmI7ALAGpQLzwDosYJzxM1x7QkF9D8pGx-4ZFzYJosKHqvO3hMyEn4hdwKZJW4lanRspqOXoPfv-19dT1lvGR9gYWClNvoUg6C2mYIwFLOXMBzy4TBD8e9x1QMqenwM6QfebskFseSc_pZoJuBJOb9LDu9_uq5aCpf7mfPyVwJQTdzqyhaKQHzzEk9vG4la4Xbb6Z-zw';
$BASE  = 'https://5sim.net/v1';

// ---------- Headers dasar ----------
if (!isset($_GET['action']) && !isset($_POST['action'])) {
    header('X-Content-Type-Options: nosniff');
    header('Referrer-Policy: no-referrer');
    header('X-Frame-Options: DENY');
}

// ---------- Helper CSRF ----------
if (empty($_SESSION['csrf'])) {
    $_SESSION['csrf'] = bin2hex(random_bytes(16));
}
function check_csrf(): void {
    if ($_SERVER['REQUEST_METHOD'] === 'POST') {
        $token = $_POST['csrf'] ?? $_SERVER['HTTP_X_CSRF_TOKEN'] ?? '';
        if (!hash_equals($_SESSION['csrf'] ?? '', (string)$token)) {
            http_response_code(400);
            header('Content-Type: application/json; charset=utf-8');
            echo json_encode(['error' => 'Invalid CSRF token']);
            exit;
        }
    }
}

// ---------- Login / Logout ----------
$op = $_GET['op'] ?? $_POST['op'] ?? null;

// Proses logout
if ($op === 'logout') {
    session_regenerate_id(true);
    $_SESSION = [];
    session_destroy();
    header('Location: ' . strtok($_SERVER['REQUEST_URI'], '?'));
    exit;
}

// Proses login
if ($op === 'login' && $_SERVER['REQUEST_METHOD'] === 'POST') {
    check_csrf();
    $u = trim($_POST['username'] ?? '');
    $p = (string)($_POST['password'] ?? '');
    $ok = ($u === $GLOBALS['APP_USER'] && $p === $GLOBALS['APP_PASS']);
    if ($ok) {
        session_regenerate_id(true);
        $_SESSION['authed'] = true;
        header('Location: ' . strtok($_SERVER['REQUEST_URI'], '?'));
        exit;
    } else {
        $_SESSION['login_error'] = 'Username atau password salah.';
        header('Location: ' . strtok($_SERVER['REQUEST_URI'], '?') . '#login');
        exit;
    }
}

// ---------- Endpoint API proxy (wajib login) ----------
function api_get(string $path): array {
    global $TOKEN, $BASE;
    $ch = curl_init();
    curl_setopt_array($ch, [
        CURLOPT_URL => rtrim($BASE, '/') . $path,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_HTTPHEADER => [
            'Authorization: Bearer ' . $TOKEN,
            'Accept: application/json',
        ],
        CURLOPT_TIMEOUT => 30,
    ]);
    $res = curl_exec($ch);
    if ($res === false) {
        http_response_code(500);
        echo json_encode(['error' => curl_error($ch)]);
        curl_close($ch);
        exit;
    }
    $status = (int)curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);

    $data = json_decode($res, true);
    if ($status >= 400) {
        http_response_code($status);
        echo json_encode(['error' => $data ?: $res, 'http_status' => $status]);
        exit;
    }
    if (!is_array($data)) $data = ['raw' => $res];
    return $data;
}

$action = $_GET['action'] ?? $_POST['action'] ?? null;
if ($action) {
    header('Content-Type: application/json; charset=utf-8');

    // Gate: harus login
    if (empty($_SESSION['authed'])) {
        http_response_code(401);
        echo json_encode(['error' => 'Unauthorized']);
        exit;
    }

    // Validasi token 5SIM (opsional)
    if (strpos($TOKEN, 'PUT_YOUR_5SIM_TOKEN_HERE') !== false) {
        http_response_code(400);
        echo json_encode(['error' => 'Set FIVESIM_TOKEN env atau edit $TOKEN di file.']);
        exit;
    }

    try {
        switch ($action) {
            case 'buy':
                $country  = strtolower(trim($_REQUEST['country'] ?? 'indonesia'));
                $operator = strtolower(trim($_REQUEST['operator'] ?? 'any'));
                $product  = strtolower(trim($_REQUEST['product'] ?? 'whatsapp'));
                echo json_encode(api_get("/user/buy/activation/$country/$operator/$product"));
                break;

            case 'check':
                $id = (int)($_REQUEST['id'] ?? 0);
                if ($id <= 0) throw new RuntimeException('Missing id');
                echo json_encode(api_get("/user/check/$id"));
                break;

            case 'cancel':
                $id = (int)($_REQUEST['id'] ?? 0);
                if ($id <= 0) throw new RuntimeException('Missing id');
                echo json_encode(api_get("/user/cancel/$id"));
                break;

            case 'finish':
                $id = (int)($_REQUEST['id'] ?? 0);
                if ($id <= 0) throw new RuntimeException('Missing id');
                echo json_encode(api_get("/user/finish/$id"));
                break;

            case 'vendor':
                echo json_encode(api_get("/user/vendor"));
                break;

            default:
                http_response_code(400);
                echo json_encode(['error' => 'Unknown action']);
        }
    } catch (Throwable $e) {
        http_response_code(500);
        echo json_encode(['error' => $e->getMessage()]);
    }
    exit;
}

// ---------- Jika belum login: render halaman login dan keluar ----------
$authed = !empty($_SESSION['authed']);
if (!$authed):
?>
<!doctype html>
<html lang="id">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width,initial-scale=1,maximum-scale=1,user-scalable=no">
  <title>Masuk • DigitalVirtual</title>
  <style>
    :root{
      --bg:#0b1020; --card:#101a33; --muted:#9aa4b2; --text:#e6edf3; --line:#223355;
      --brand:#6aa5ff; --brand-2:#3b82f6; --bad:#ef4444;
    }
    *{box-sizing:border-box}
    html,body{height:100%}
    body{
      margin:0; background:linear-gradient(180deg,#07122b 0%, #0b1020 100%);
      font-family:system-ui,-apple-system, Segoe UI, Roboto, Ubuntu, 'Helvetica Neue', Arial, sans-serif;
      color:var(--text); display:grid; place-items:center;
    }
    .card{
      width:min(92vw, 380px); background:var(--card); border:1px solid var(--line);
      border-radius:16px; padding:20px; box-shadow:0 10px 30px rgba(0,0,0,.35)
    }
    h1{margin:0 0 4px; font-size:22px}
    p{margin:0 0 14px; color:var(--muted)}
    label{display:block; margin:8px 0 6px 2px; font-size:13px; color:#cdd7e3}
    input{
      width:100%; padding:12px; border-radius:10px; border:1px solid var(--line);
      background:#0c1730; color:var(--text); outline:none;
    }
    input:focus{ border-color:var(--brand-2); box-shadow:0 0 0 3px rgba(59,130,246,.25) }
    .btn{
      width:100%; margin-top:14px; padding:12px; border-radius:12px; border:0;
      background:linear-gradient(90deg,var(--brand) 0%, var(--brand-2) 100%); color:#fff; font-weight:700;
      cursor:pointer;
    }
    .err{ color:#fecaca; background:rgba(239,68,68,.12); border:1px solid #ef4444;
      padding:10px; border-radius:10px; margin-bottom:10px; font-size:13px; }
    .footer{ margin-top:10px; font-size:12px; color:var(--muted); text-align:center }
    .muted{ color:var(--muted) }
    .showpass{ display:flex; gap:8px; align-items:center; font-size:12px; margin-top:6px; color:var(--muted) }
  </style>
</head>
<body>
  <div class="card" id="login">
    <h1>Masuk</h1>
    <p>Silakan login untuk mengakses aplikasi.</p>
    <?php if (!empty($_SESSION['login_error'])): ?>
      <div class="err"><?=htmlspecialchars($_SESSION['login_error'] ?? '', ENT_QUOTES) ?></div>
      <?php $_SESSION['login_error'] = null; endif; ?>
    <form method="post" action="?op=login">
      <input type="hidden" name="csrf" value="<?=htmlspecialchars($_SESSION['csrf'], ENT_QUOTES)?>">
      <label>Username</label>
      <input name="username" placeholder="username" required autofocus>
      <label>Password</label>
      <input id="pwd" type="password" name="password" placeholder="password" required>
      <label class="showpass"><input type="checkbox" onclick="document.getElementById('pwd').type=this.checked?'text':'password'"> Tampilkan password</label>
      <button class="btn" type="submit">Masuk</button>
    </form>
   
  </div>
</body>
</html>
<?php
exit;
endif; // end login gate
?>

<!doctype html>
<html lang="id">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width,initial-scale=1,maximum-scale=1,user-scalable=no">
  <title>DigitalVirtual OTP Receiver</title>
  <style>
    :root{
      --bg:#0b1020; --card:#101a33; --muted:#9aa4b2; --text:#e6edf3; --line:#223355;
      --brand:#6aa5ff; --brand-2:#3b82f6; --good:#22c55e; --warn:#f59e0b; --bad:#ef4444;
      --chip:#1f2b4a; --chip-t:#c7d2fe;
    }
    *{box-sizing:border-box}
    html,body{height:100%}
    body{
      margin:0; background:linear-gradient(180deg,#07122b 0%, #0b1020 100%);
      font-family:system-ui, -apple-system, Segoe UI, Roboto, Ubuntu, 'Helvetica Neue', Arial, sans-serif;
      color:var(--text);
    }
    .appbar{
      position:sticky; top:0; z-index:50; backdrop-filter: blur(6px);
      background:rgba(7,17,43,.7); border-bottom:1px solid rgba(255,255,255,.08);
      display:flex; align-items:center; justify-content:space-between;
      padding:12px 16px;
    }
    .brand{font-weight:700; letter-spacing:.3px}
    .container{max-width:960px; margin:0 auto; padding:16px}
    .grid{display:grid; gap:12px}
    @media(min-width:768px){ .grid.cols-3{ grid-template-columns: repeat(3, 1fr);} }
    .card{
      background:var(--card); border:1px solid var(--line);
      border-radius:14px; padding:16px; box-shadow:0 6px 20px rgba(0,0,0,.25);
    }
    h1{font-size:20px;margin:0 0 6px}
    h2{font-size:16px;margin:0 0 10px}
    p{margin:0 0 8px}
    label{display:block; margin:6px 0 6px 2px; font-size:13px; color:#cdd7e3}
    input, select{
      width:100%; padding:12px 12px; border-radius:10px; border:1px solid var(--line);
      background:#0c1730; color:var(--text); outline:none;
    }
    input:focus, select:focus{ border-color:var(--brand-2); box-shadow:0 0 0 3px rgba(59,130,246,.25) }
    .actions{display:flex; gap:10px; flex-wrap:wrap}
    .btn{
      appearance:none; border:1px solid transparent; border-radius:12px; padding:12px 14px;
      font-weight:600; cursor:pointer; transition:.15s transform ease, .15s opacity ease;
    }
    .btn:active{ transform:scale(.98) }
    .btn-primary{ background:linear-gradient(90deg,var(--brand) 0%, var(--brand-2) 100%); color:white}
    .btn-ghost{ background:transparent; border-color:var(--line); color:#cfe1ff }
    .btn-danger{ background:rgba(239,68,68,.12); border-color:#ef4444; color:#ffb4b4 }
    .btn-success{ background:rgba(34,197,94,.15); border-color:#16a34a; color:#b5f1c4 }
    .btn-sm{ padding:8px 10px; border-radius:10px; font-size:12px }
    .muted{ color:var(--muted) }
    .row{display:grid; gap:10px}
    @media(min-width:768px){ .row{ grid-template-columns: repeat(3, minmax(0,1fr)); } }
    .badge{
      display:inline-flex; align-items:center; gap:6px; padding:4px 8px; border-radius:999px;
      font-size:12px; background:var(--chip); color:var(--chip-t); border:1px solid var(--line)
    }
    .status-wait{ background:rgba(59,130,246,.15); color:#bfdbfe; border-color:#3b82f6 }
    .status-finished{ background:rgba(34,197,94,.18); color:#bbf7d0; border-color:#22c55e }
    .status-canceled{ background:rgba(239,68,68,.18); color:#fecaca; border-color:#ef4444 }
    pre{
      background:#0a142d; border:1px solid var(--line); padding:12px; border-radius:12px;
      font-family: ui-monospace, SFMono-Regular, Menlo, Consolas, "Liberation Mono", monospace;
      font-size:13px; color:#d7e6ff; overflow:auto; max-height:40vh;
    }
    .meta{display:flex; gap:12px; flex-wrap:wrap; align-items:center}
    .kv{display:flex; gap:6px; align-items:center; background:#0f1a33; border:1px dashed var(--line); border-radius:10px; padding:8px 10px; font-size:13px}
    .copy-btn{ margin-left:8px }
    .header-row{display:flex; align-items:center; justify-content:space-between; gap:10px}
    .spinner{ width:16px; height:16px; border:2px solid rgba(255,255,255,.4); border-top-color:#fff; border-radius:50%; animation:spin 1s linear infinite; display:inline-block; vertical-align:middle }
    @keyframes spin{ to{ transform: rotate(360deg) } }
    .toasts{ position:fixed; left:50%; transform:translateX(-50%); bottom:16px; z-index:60; display:flex; flex-direction:column; gap:8px; width:min(92%, 420px) }
    .toast{ background:#0e1b36; border:1px solid var(--line); color:#e6f0ff; padding:10px 12px; border-radius:12px; box-shadow:0 10px 26px rgba(0,0,0,.35); font-size:14px; display:flex; align-items:center; justify-content:space-between; gap:12px }
    .hide{ display:none }
    .right{ display:flex; align-items:center; gap:8px }
    a.logout{ color:#fca5a5; text-decoration:none; border:1px solid #ef4444; padding:6px 10px; border-radius:10px; font-size:12px }
    a.logout:hover{ background:rgba(239,68,68,.1) }
  </style>
</head>
<body>
  <div class="appbar">
    <div class="brand">DigitalVirtual • OTP Receiver</div>
    <div class="right">
      <span class="muted" style="font-size:12px">Signed in</span>
      <a class="logout" href="?op=logout">Logout</a>
    </div>
  </div>

  <div class="container">

    <div id="wallet" class="card">
      <div class="header-row">
        <h2>Saldo Akun</h2>
        <button id="btnRefreshBalance" class="btn btn-ghost btn-sm">Refresh</button>
      </div>
      <div class="meta" style="margin-top:8px">
        <div class="kv"><b>Balance:</b>&nbsp;<span id="balanceSymbol">$</span><span id="balance">0.00</span></div>
      </div>
    </div>

    <div class="card">
      <h1>Pesan Nomor</h1>
      <p class="muted">Pilih layanan, negara, dan operator. Sistem akan membeli nomor virtual dan menunggu SMS berisi kode OTP.</p>

      <form id="form" style="margin-top:12px">
        <input type="hidden" name="csrf" id="csrf" value="<?=htmlspecialchars($_SESSION['csrf'], ENT_QUOTES)?>">
        <div class="row">
          <div>
            <label for="product">Layanan (product)</label>
            <select name="product" id="product" required>
              <option value="whatsapp">WhatsApp</option>
              <option value="telegram">Telegram</option>
              <option value="google">Google</option>
              <option value="instagram">Instagram</option>
              <option value="facebook">Facebook</option>
              <option value="tiktok">TikTok</option>
              <option value="twitter">Twitter</option>
              <option value="other">Other</option>
            </select>
          </div>
          <div>
            <label for="country">Negara</label>
            <input name="country" id="country" value="indonesia" required placeholder="mis: indonesia, usa, england">
          </div>
          <div>
            <label for="operator">Operator</label>
            <select name="operator" id="operator" required>
              <option value="virtual53">Virtual53</option>
              <option value="any">Any operator</option>
              <option value="virtual38">Virtual38</option>
              <option value="virtual21">Virtual21</option>
            </select>
          </div>
        </div>
        <div class="actions" style="margin-top:12px">
          <button id="btnBuy" type="submit" class="btn btn-primary">
            <span class="buy-label">Beli Nomor &amp; Mulai</span>
            <span class="buy-loading hide"><span class="spinner"></span> &nbsp;Memproses...</span>
          </button>
        </div>
      </form>
    </div>

    <div id="order" class="card hide">
      <div class="header-row">
        <h2>Status Pesanan</h2>
        <span id="status" class="badge status-wait">WAITING</span>
      </div>

      <div class="meta" style="margin-top:8px">
        <div class="kv"><b>Order ID:</b> <span id="orderId"></span></div>
        <div class="kv"><b>Harga:</b> <span id="priceSymbol">$</span><span id="price">0.00</span></div>
      </div>

      <div class="meta" style="margin-top:8px">
        <div class="kv"><b>Nomor:</b> <span id="phone"></span></div>
        <button id="btnCopyPhone" class="btn btn-ghost btn-sm copy-btn">Copy Nomor</button>
      </div>

      <div class="actions" style="margin-top:14px">
        <button id="btnFinish" class="btn btn-success">Finish</button>
        <button id="btnCancel" class="btn btn-danger">Cancel</button>
      </div>
    </div>

    <div id="sms" class="card hide">
      <div class="header-row">
        <h2>SMS Masuk</h2>
        <button id="btnCopyOtp" class="btn btn-ghost btn-sm">Copy OTP</button>
      </div>
      <pre id="smsBox">// menunggu SMS...</pre>
    </div>

  </div>

  <!-- Audio bel -->
  <audio id="bellSound" src="bell.mp3" preload="auto"></audio>

  <!-- Toast container -->
  <div class="toasts" id="toasts"></div>

<script>
const $ = s => document.querySelector(s);

let pollTimer = null;
let currentOrderId = null;
let lastOTP = '';
let lastPrice = 0;
let lastCurrency = 'USD';
let lastSmsLen = 0;
let prevOTP = '';

// ---------- UI helpers ----------
function show(el){ el.classList.remove('hide'); }
function hide(el){ el.classList.add('hide'); }
function toggleBuyLoading(on){
  const btn = $('#btnBuy');
  const lbl = btn.querySelector('.buy-label');
  const loading = btn.querySelector('.buy-loading');
  if(on){ lbl.classList.add('hide'); loading.classList.remove('hide'); btn.disabled = true; }
  else { loading.classList.add('hide'); lbl.classList.remove('hide'); btn.disabled = false; }
}
function badgeClassFor(status){
  const s = String(status||'').toUpperCase();
  if (['PENDING','WAITING','RECEIVED'].includes(s)) return 'badge status-wait';
  if (['FINISHED'].includes(s)) return 'badge status-finished';
  if (['CANCELED','TIMEOUT','BANNED'].includes(s)) return 'badge status-canceled';
  return 'badge';
}
function toast(msg, kind='info', timeout=2800){
  const wrap = $('#toasts');
  const div = document.createElement('div');
  div.className = 'toast';
  if(kind==='ok') div.style.borderColor = '#22c55e';
  if(kind==='warn') div.style.borderColor = '#f59e0b';
  if(kind==='err') div.style.borderColor = '#ef4444';
  div.innerHTML = `<span>${msg}</span><button class="btn btn-ghost btn-sm">Tutup</button>`;
  div.querySelector('button').onclick = ()=> wrap.removeChild(div);
  wrap.appendChild(div);
  setTimeout(()=>{ if(wrap.contains(div)) wrap.removeChild(div); }, timeout);
}

// ---------- AUDIO (BEL) + NOTIF ----------
function playBell(){
  const el = document.getElementById('bellSound');
  if (el){
    try { el.currentTime = 0; } catch(_){}
    el.play().catch(()=>{ /* might be blocked until first gesture */ });
  }
}
function ensureNotifyPermission(){
  if ('Notification' in window && Notification.permission === 'default'){
    Notification.requestPermission().catch(()=>{});
  }
}
function notify(title, body){
  if ('Notification' in window && Notification.permission === 'granted'){
    try { new Notification(title, { body }); } catch (_) {}
  }
}

// ---------- UTIL ----------
function symbolFor(cur){
  const m = String(cur||'USD').toUpperCase();
  if (m === 'USD' || m === '$') return '$';
  if (m === 'IDR' || m === 'RP') return 'Rp';
  if (m === 'EUR') return '€';
  if (m === 'GBP') return '£';
  if (m === 'RUB') return '₽';
  if (m === 'VND') return '₫';
  return m + ' ';
}
function copyToClipboard(text){
  if(!text){ toast('Tidak ada yang disalin','warn'); return; }
  navigator.clipboard?.writeText(text).then(()=>{
    toast('Disalin ke clipboard','ok');
  }).catch(()=>{
    const ta = document.createElement('textarea');
    ta.value = text; document.body.appendChild(ta); ta.select();
    try{ document.execCommand('copy'); toast('Disalin ke clipboard','ok'); }catch(e){ toast('Gagal menyalin','err'); }
    document.body.removeChild(ta);
  });
}
function sanitizePhoneForCopy(raw){
  const ccMap = {
    indonesia:'62', usa:'1', england:'44', russia:'7', vietnam:'84',
    india:'91', china:'86', thailand:'66', malaysia:'60', philippines:'63'
  };
  let p = String(raw||'').trim().replace(/\s|-/g,'');
  if (p.startsWith('+')) p = p.slice(1);
  const c = ($('#country')?.value || '').toLowerCase().trim();
  const cc = ccMap[c];
  if (cc && p.startsWith(cc)) p = p.slice(cc.length);
  return p;
}

// ---------- RENDER SMS ----------
function renderSMS(smsArr){
  if(!smsArr || smsArr.length === 0){
    $('#smsBox').textContent = '// belum ada SMS masuk';
    return;
  }
  window._lastSms = smsArr;
  const lines = smsArr.map(s => {
    const when = new Date(s.date || s.created_at || Date.now()).toLocaleString();
    let __code = '';
    if (s.code && String(s.code).trim()){
      __code = String(s.code).trim();
      lastOTP = __code;
    } else if (s.text){
      const m = String(s.text).match(/\b\d{4,8}\b/);
      if(m){ __code = m[0]; lastOTP = __code; }
    }
    const code = __code ? ` (code: ${__code})` : '';
    return `[${when}] ${s.sender || 'unknown'}: ${s.text}${code}`;
  });
  $('#smsBox').textContent = lines.join('\n');
}

// ---------- API WRAPPER ----------
async function api(action, params={}){
  const csrf = $('#csrf')?.value || '';
  const qs = new URLSearchParams({action, ...params});
  const res = await fetch('index.php?' + qs.toString(), {
    method: 'GET',
    headers:{ 'Accept':'application/json', 'X-CSRF-Token': csrf }
  });
  const data = await res.json().catch(()=> ({}));
  if(!res.ok){
    if(res.status === 401){ toast('Sesi berakhir. Silakan login lagi.','err',4000); setTimeout(()=>location.reload(), 1200); }
    throw new Error((data && data.error) ? JSON.stringify(data.error) : res.status + ' error');
  }
  return data;
}
function setStatus(s){
  const el = $('#status');
  el.textContent = s;
  el.className = badgeClassFor(s);
}

// ---------- POLLING ----------
async function startPolling(id){
  if(pollTimer) clearInterval(pollTimer);
  lastSmsLen = 0;
  prevOTP = '';
  pollTimer = setInterval(async () => {
    try{
      const data = await api('check', {id});
      setStatus(data.status || 'UNKNOWN');
      const smsArr = data.sms || [];
      const hadNewSms = smsArr.length > lastSmsLen;

      renderSMS(smsArr);
      show($('#sms'));

      if (hadNewSms){
        playBell();
        notify('SMS masuk', `Pesan baru untuk order ${id}`);
        toast('SMS baru diterima','ok',2200);
      }
      if (lastOTP && lastOTP !== prevOTP){
        playBell();
        notify('Kode OTP diterima', `Kode: ${lastOTP}`);
        toast('OTP diterima: ' + lastOTP,'ok',2600);
        prevOTP = lastOTP;
      }
      lastSmsLen = smsArr.length;

      const st = (data.status||'').toUpperCase();
      if(['FINISHED','CANCELED','TIMEOUT','BANNED'].includes(st)){
        clearInterval(pollTimer);
        toast('Order ' + st, (st==='FINISHED'?'ok':'warn'), 2400);
      }
    }catch(e){ console.error(e); }
  }, 5000);
}

// ---------- FORM SUBMIT ----------
$('#form').addEventListener('submit', async (e) => {
  e.preventDefault();
  try{
    ensureNotifyPermission();
    toggleBuyLoading(true);

    // 1) saldo/currency sebelum beli (fallback harga)
    const vendorBefore = await api('vendor');
    const beforeRaw = (typeof vendorBefore.balance !== 'undefined') ? vendorBefore.balance : (vendorBefore.data && vendorBefore.data.balance);
    const beforeBal = (typeof beforeRaw === 'number') ? beforeRaw : (parseFloat(beforeRaw) || 0);
    lastCurrency = (vendorBefore.currency || (vendorBefore.data && vendorBefore.data.currency) || lastCurrency);
    $('#balanceSymbol').textContent = symbolFor(lastCurrency);

    const product = $('#product').value.trim().toLowerCase();
    const country = $('#country').value.trim().toLowerCase();
    const operator = $('#operator').value.trim().toLowerCase();

    // 2) Beli nomor
    const data = await api('buy', {product, country, operator});

    currentOrderId = data.id;
    $('#orderId').textContent = data.id;
    $('#phone').textContent = data.phone;
    setStatus(data.status || 'PENDING');
    show($('#order'));
    show($('#sms'));
    renderSMS([]);
    lastSmsLen = 0;
    prevOTP = '';

    // bunyi + notif sukses beli
    playBell();
    notify('Nomor berhasil dibeli', `Order ${data.id} • ${data.phone || ''}`);
    toast('Nomor berhasil dibeli','ok');

    // 3) Harga dari response
    let priceResp = null;
    if (typeof data.price !== 'undefined') priceResp = parseFloat(data.price) || 0;
    else if (typeof data.cost !== 'undefined') priceResp = parseFloat(data.cost) || 0;
    if (priceResp && !Number.isNaN(priceResp)) lastPrice = priceResp;

    // 4) saldo setelah beli -> delta jika harga kosong
    try{
      const vendorAfter = await api('vendor');
      const afterRaw = (typeof vendorAfter.balance !== 'undefined') ? vendorAfter.balance : (vendorAfter.data && vendorAfter.data.balance);
      const afterBal = (typeof afterRaw === 'number') ? afterRaw : (parseFloat(afterRaw) || 0);

      const cur = (vendorAfter.currency || (vendorAfter.data && vendorAfter.data.currency) || lastCurrency);
      lastCurrency = cur || lastCurrency;

      if ((!lastPrice || lastPrice === 0) && beforeBal && afterBal >= 0){
        const delta = beforeBal - afterBal;
        if (delta > 0) lastPrice = delta;
      }

      // Render harga & saldo terbaru
      $('#priceSymbol').textContent = symbolFor(lastCurrency);
      $('#price').textContent = (lastPrice || 0).toFixed(2);
      $('#balanceSymbol').textContent = symbolFor(lastCurrency);
      $('#balance').textContent = afterBal.toFixed(2);
    }catch(_) {}

    startPolling(data.id);
  }catch(err){
    console.error(err);
    toast('Gagal membuat order','err');
  }finally{
    toggleBuyLoading(false);
  }
});

// ---------- ACTION BUTTONS ----------
$('#btnCancel').addEventListener('click', async () => {
  if(!currentOrderId) return;
  try{
    const data = await api('cancel', {id: currentOrderId});
    setStatus(data.status || 'CANCELED');
    clearInterval(pollTimer);
    toast('Order dibatalkan','warn');
  }catch(err){ toast('Gagal cancel','err'); }
});
$('#btnFinish').addEventListener('click', async () => {
  if(!currentOrderId) return;
  try{
    const data = await api('finish', {id: currentOrderId});
    setStatus(data.status || 'FINISHED');
    clearInterval(pollTimer);
    toast('Order selesai','ok');
  }catch(err){ toast('Gagal finish','err'); }
});

// ---------- COPY ----------
$('#btnCopyPhone').addEventListener('click', ()=>{
  const raw = ($('#phone')||{}).textContent || '';
  const local = sanitizePhoneForCopy(raw);
  copyToClipboard(local || raw);
});
$('#btnCopyOtp').addEventListener('click', ()=>{
  if(!lastOTP){ toast('Kode OTP belum tersedia','warn'); return; }
  copyToClipboard(lastOTP);
});

// ---------- SALDO ----------
async function loadBalance(){
  try{
    const prof = await api('vendor');
    const balRaw = (typeof prof.balance !== 'undefined') ? prof.balance : (prof.data && prof.data.balance);
    const bal = (typeof balRaw === 'number') ? balRaw : (parseFloat(balRaw) || 0);
    const cur = (prof.currency || (prof.data && prof.data.currency) || lastCurrency || 'USD');
    lastCurrency = cur;
    $('#balance').textContent = bal.toFixed(2);
    $('#balanceSymbol').textContent = symbolFor(cur);
    $('#priceSymbol').textContent = symbolFor(cur);
  }catch(e){
    console.error('Gagal ambil saldo', e);
    toast('Tidak dapat memuat saldo','warn');
  }
}
$('#btnRefreshBalance').addEventListener('click', loadBalance);

// Init
window.addEventListener('DOMContentLoaded', () => {
  loadBalance();
});
</script>
</body>
</html>
