<?php
declare(strict_types=1);
session_start();

/**
 * SMS-Activate .AE — Single-file Web (index.php)
 * - Sidebar: Filter + Hapus per filter, Saldo (auto-hide), Pengaturan (auto-hide)
 * - Country: hanya Indonesia
 * - Service: hanya "wa" (WhatsApp) + harga $
 * - Operator: Any / telkomsel / axis / three (+ stok)
 * - Pieces: multi pembelian
 * - Persist aktivasi di localStorage (tetap ada setelah refresh)
 * - Daftar semua nomor yang masih proses (belum batal)
 * - Format: Nomor (copy lokal) + $Harga | Status | Batal | Kode SMS (copy)
 * - Auto-polling status untuk semua aktivasi yang belum batal
 * - Hapus daftar per filter + "Hapus yang ditampilkan"
 * - Urutan daftar: TERBARU DI ATAS (descending by createdAt)
 */

$HARDCODE_API_KEY = 'd30fc78e7ce562c9d5ccdc7A6e286b67'; // untuk produksi, pakai ENV SMSA_API_KEY
$API_KEY  = getenv('SMSA_API_KEY') ?: $HARDCODE_API_KEY;
$API_BASE = getenv('SMSA_API_BASE') ?: 'https://api.sms-activate.ae/stubs/handler_api.php';

if (empty($_SESSION['csrf'])) $_SESSION['csrf'] = bin2hex(random_bytes(16));
function check_csrf(): void {
  if ($_SERVER['REQUEST_METHOD']==='POST') {
    $ok = isset($_POST['csrf']) && hash_equals($_SESSION['csrf']??'', $_POST['csrf']);
    if (!$ok) { http_response_code(400); header('Content-Type: application/json'); echo json_encode(['ok'=>false,'error'=>'Invalid CSRF']); exit; }
  }
}

function sa_call(array $params, int $timeout=20): array {
  global $API_KEY, $API_BASE;
  if (!$API_KEY) return ['ok'=>false,'error'=>'API key belum diset (ENV SMSA_API_KEY).'];
  $params = array_merge(['api_key'=>$API_KEY], $params);
  $url = $API_BASE.'?'.http_build_query($params);

  $ch = curl_init();
  curl_setopt_array($ch, [
    CURLOPT_URL=>$url, CURLOPT_RETURNTRANSFER=>true,
    CURLOPT_CONNECTTIMEOUT=>$timeout, CURLOPT_TIMEOUT=>$timeout,
    CURLOPT_SSL_VERIFYPEER=>true, CURLOPT_SSL_VERIFYHOST=>2,
    CURLOPT_HTTPHEADER=>['Accept: */*','User-Agent: SMSA-OTP/2.4']
  ]);
  $res = curl_exec($ch); $err = curl_error($ch); $code=(int)curl_getinfo($ch, CURLINFO_HTTP_CODE); curl_close($ch);
  if ($err) return ['ok'=>false,'error'=>'cURL error: '.$err];
  if ($code<200 || $code>=300) return ['ok'=>false,'error'=>'HTTP '.$code];
  return ['ok'=>true,'raw'=>$res];
}
function parse_handler_text(string $raw): array {
  $parts = explode(':', trim($raw));
  return ['raw'=>$raw,'tag'=>$parts[0]??null,'parts'=>$parts];
}
function json_response($data, int $status=200): void {
  header('Content-Type: application/json; charset=utf-8'); http_response_code($status); echo json_encode($data, JSON_UNESCAPED_UNICODE); exit;
}
function extract_otp(string $raw): ?string {
  if (preg_match('/STATUS_OK:(\d{4,8})/i',$raw,$m)) return $m[1];
  if (preg_match('/\b(\d{4,8})\b/',$raw,$m)) return $m[1];
  return null;
}
function find_operator_counts(array $node, array $ops): array {
  $out = array_fill_keys($ops, null);
  $it = new RecursiveIteratorIterator(new RecursiveArrayIterator($node), RecursiveIteratorIterator::SELF_FIRST);
  foreach ($it as $k => $v) {
    if (!is_string($k)) continue;
    $kl = strtolower($k);
    if (in_array($kl, $ops, true)) {
      if (is_array($v) && array_key_exists('count', $v) && is_numeric($v['count'])) {
        $out[$kl] = (int)$v['count'];
      }
    }
  }
  return $out;
}

if (isset($_GET['ajax'])) {
  header('Cache-Control: no-store');
  $action = $_GET['ajax'];
  if ($_SERVER['REQUEST_METHOD']==='POST') check_csrf();

  switch ($action) {
    case 'balance': {
      $r=sa_call(['action'=>'getBalance']); if(!$r['ok']) json_response($r,500);
      json_response(['ok'=>true,'data'=>parse_handler_text($r['raw'])]);
    } break;

    case 'countries': { // hanya Indonesia
      $r=sa_call(['action'=>'getCountries']); if(!$r['ok']) json_response($r,500);
      $j=json_decode($r['raw'],true); if(json_last_error()!==JSON_ERROR_NONE) json_response(['ok'=>false,'error'=>'Invalid JSON','raw'=>$r['raw']],500);
      $indoKey=null; $indoObj=null;
      foreach ($j as $k=>$v) {
        $name = strtolower($v['eng'] ?? $v['rus'] ?? '');
        if (strpos($name,'indonesia')!==false) { $indoKey=$k; $indoObj=$v; break; }
      }
      if (!$indoKey) { $indoKey = array_key_exists('6',$j)?'6':'0'; $indoObj = $j[$indoKey] ?? ['eng'=>'Indonesia']; }
      json_response(['ok'=>true,'data'=>[$indoKey=>$indoObj]]);
    } break;

    case 'prices': {
      $country=trim($_GET['country']??'0'); $service=trim($_GET['service']??'');
      $p=['action'=>'getPrices','country'=>$country]; if($service!=='') $p['service']=$service;
      $r=sa_call($p); if(!$r['ok']) json_response($r,500);
      $j=json_decode($r['raw'],true); if(json_last_error()===JSON_ERROR_NONE) json_response(['ok'=>true,'data'=>$j]);
      json_response(['ok'=>true,'raw'=>$r['raw']]);
    } break;

    case 'operator_stock': {
      $country=trim($_GET['country']??'0'); $service=trim($_GET['service']??'');
      if($service==='') json_response(['ok'=>false,'error'=>'service wajib'],400);
      $r=sa_call(['action'=>'getPrices','country'=>$country]); if(!$r['ok']) json_response($r,500);
      $j=json_decode($r['raw'],true); if(json_last_error()!==JSON_ERROR_NONE) json_response(['ok'=>false,'error'=>'Invalid JSON','raw'=>$r['raw']],500);
      $svcNode = null; $anyCount = null;
      if (isset($j[$service]) && is_array($j[$service])) { $svcNode = $j[$service]; }
      if (isset($j[$country][$service]) && is_array($j[$country][$service])) { $svcNode = $j[$country][$service]; }
      if (!$svcNode) {
        $iter = new RecursiveIteratorIterator(new RecursiveArrayIterator($j), RecursiveIteratorIterator::SELF_FIRST);
        foreach ($iter as $k=>$v) { if ($k===$service && is_array($v)) { $svcNode=$v; break; } }
      }
      if (is_array($svcNode) && isset($svcNode['count']) && is_numeric($svcNode['count'])) $anyCount=(int)$svcNode['count'];
      $ops = ['any','telkomsel','axis','three'];
      $opCounts = ['any'=>$anyCount, 'telkomsel'=>null, 'axis'=>null, 'three'=>null];
      if ($svcNode) {
        $found = find_operator_counts($svcNode, ['telkomsel','axis','three']);
        $opCounts = array_merge($opCounts, array_intersect_key($found, ['telkomsel'=>1,'axis'=>1,'three'=>1]));
      }
      json_response(['ok'=>true,'data'=>$opCounts]);
    } break;

    case 'buy_number': {
      $service=trim($_POST['service']??''); $country=trim($_POST['country']??'0'); $operator=trim($_POST['operator']??'any');
      $pieces=(int)($_POST['pieces']??1); if($pieces<1) $pieces=1; if($pieces>50) $pieces=50;
      if($service==='') json_response(['ok'=>false,'error'=>'Service wajib diisi.'],400);
      $items=[]; $errors=[];
      for ($i=0; $i<$pieces; $i++) {
        $r=sa_call(['action'=>'getNumber','service'=>$service,'country'=>$country,'operator'=>$operator]);
        if(!$r['ok']) { $errors[]=$r['error']; continue; }
        $p=parse_handler_text($r['raw']);
        if(($p['tag']??'')==='ACCESS_NUMBER' && count($p['parts'])>=3){
          $items[]=['id'=>$p['parts'][1],'number'=>$p['parts'][2],'raw'=>$r['raw']];
        } else { $errors[]=$r['raw']; }
      }
      if (empty($items)) json_response(['ok'=>false,'error'=>implode(' | ',$errors)],400);
      json_response(['ok'=>true,'items'=>$items,'errors'=>$errors]);
    } break;

    case 'status': {
      $id=trim($_GET['id']??''); if($id==='') json_response(['ok'=>false,'error'=>'id kosong'],400);
      $r=sa_call(['action'=>'getStatus','id'=>$id]); if(!$r['ok']) json_response($r,500);
      $p=parse_handler_text($r['raw']); $otp=extract_otp($r['raw']); json_response(['ok'=>true,'raw'=>$r['raw'],'parsed'=>$p,'otp'=>$otp]);
    } break;

    case 'set_status': {
      $id=trim($_POST['id']??''); $st=trim($_POST['status']??''); if($id===''||$st==='') json_response(['ok'=>false,'error'=>'id/status kosong'],400);
      $r=sa_call(['action'=>'setStatus','id'=>$id,'status'=>$st]); if(!$r['ok']) json_response($r,500);
      json_response(['ok'=>true,'raw'=>$r['raw']]);
    } break;

    default:
      json_response(['ok'=>false,'error'=>'aksi ajax tidak dikenal'],404);
  }
  exit;
}
?>
<!doctype html>
<html lang="id">
<head>
<meta charset="utf-8">
<title>OTP Receiver — VIRTUAL DIGITAL</title>
<meta name="viewport" content="width=device-width, initial-scale=1">
<style>
:root{
  color-scheme:light dark;
  --bg:#0f1113; --card:#14181c; --muted:#97a3b6; --text:#e9eef5; --primary:#2563eb; --border:#22272b;
  --shadow:0 6px 18px rgba(0,0,0,.22); --radius:12px;
  --pad:10px; --btnp:6px 10px; --btnr:8px;
  font-family:system-ui,-apple-system,Segoe UI,Roboto,Ubuntu,Cantarell,Helvetica,Arial
}
*{box-sizing:border-box}
body{margin:0;background:linear-gradient(180deg,#0b0f13,#12161a);color:var(--text)}
.app{display:flex;min-height:100dvh}
.sidebar{width:310px;background:#0c1117;border-right:1px solid var(--border);padding:12px;position:sticky;top:0;height:100dvh;overflow:auto}
.brand{display:flex;align-items:center;gap:10px;margin-bottom:8px}
.brand .logo{width:22px;height:22px;border-radius:6px;background:linear-gradient(135deg,#2563eb,#60a5fa)}
.brand h2{margin:0;font-size:15px;letter-spacing:.3px}
.sectionTitle{color:var(--muted);font-size:.9rem;margin:10px 0 6px}
.card{background:var(--card);border:1px solid var(--border);border-radius:var(--radius);box-shadow:var(--shadow);padding:var(--pad);margin-bottom:10px}
.badge{display:inline-block;padding:3px 7px;border:1px solid var(--border);border-radius:999px;font-size:.75rem;color:var(--muted)}
.btn{display:inline-flex;align-items:center;gap:6px;justify-content:center;padding:var(--btnp);border-radius:var(--btnr);border:1px solid #334155;background:#121821;color:var(--text);cursor:pointer;font-size:.9rem}
.btn-primary{background:var(--primary);border-color:#1e4ed8}
.btn-ghost{background:transparent;border-color:#2a3138}
.btn-danger{background:#b91c1c;border-color:#991b1b}
.btn:disabled{opacity:.6;cursor:not-allowed}
.btn-sm{padding:4px 8px;border-radius:7px;font-size:.85rem}
input,select{padding:8px 10px;border-radius:9px;border:1px solid #2a3138;background:#0f141a;color:var(--text);width:100%;font-size:.95rem}
label{display:block;font-weight:600;margin-bottom:5px;font-size:.92rem}
.row{display:grid;grid-template-columns:repeat(12,1fr);gap:10px}
.col-12{grid-column:span 12}
.mono{font-family:ui-monospace,Menlo,Consolas,monospace}
.muted{color:var(--muted);font-size:.9rem}
.hidden{display:none}
details{border:1px solid var(--border);border-radius:10px;background:#0f141a;margin-bottom:10px}
details summary{cursor:pointer;padding:8px 10px;color:#d4d9e1;font-weight:600}
details .content{padding:0 10px 10px}
.main{flex:1;padding:12px 14px}
.topbar{display:flex;align-items:center;justify-content:space-between;margin-bottom:10px}
.hamburger{display:none}
.table{width:100%;border-collapse:collapse}
.table th,.table td{border-top:1px solid #2a3138;padding:8px 6px;vertical-align:top;font-size:.95rem}
.table th{font-weight:700;color:#cfd6df}
.cardItem{display:none;border:1px solid #2a3138;background:#0f141a;border-radius:10px;padding:10px;margin-bottom:8px}
.cellActions{display:flex;gap:6px;flex-wrap:wrap;align-items:center}
.copybtn{white-space:nowrap}
.small{font-size:.85rem}
.filterRow{display:flex;align-items:center;gap:6px}
.filterRow .grow{flex:1}
@media (max-width: 900px){
  .sidebar{position:fixed;left:-320px;top:0;height:100dvh;z-index:1000;transition:left .2s}
  .sidebar.open{left:0}
  .overlay{position:fixed;inset:0;background:rgba(0,0,0,.4);backdrop-filter:blur(1px);display:none;z-index:999}
  .overlay.show{display:block}
  .hamburger{display:inline-flex}
  .table{display:none}
  .cardItem{display:block}
}
</style>
</head>
<body>
<div class="app">
  <aside class="sidebar" id="sidebar">
    <div class="brand"><div class="logo"></div><h2>SMS VIRTUAL DIGITAL</h2></div>

    <!-- Filters + HAPUS per filter -->
    <div class="sectionTitle">Filter Aktivasi</div>
    <div class="card" style="padding:8px">
      <div class="filterRow">
        <button class="btn btn-sm grow" data-filter="inprogress">In Progress <span class="badge" id="c_inprogress">0</span></button>
        <button class="btn btn-ghost btn-sm" title="Hapus In Progress" onclick="clearFilter('inprogress')">🗑</button>
      </div>
      <div class="filterRow" style="margin-top:6px">
        <button class="btn btn-sm grow" data-filter="completed">Completed <span class="badge" id="c_completed">0</span></button>
        <button class="btn btn-ghost btn-sm" title="Hapus Completed" onclick="clearFilter('completed')">🗑</button>
      </div>
      <div class="filterRow" style="margin-top:6px">
        <button class="btn btn-sm grow" data-filter="cancelled">Cancelled <span class="badge" id="c_cancelled">0</span></button>
        <button class="btn btn-ghost btn-sm" title="Hapus Cancelled" onclick="clearFilter('cancelled')">🗑</button>
      </div>
      <div class="filterRow" style="margin-top:6px">
        <button class="btn btn-sm grow" data-filter="all">All <span class="badge" id="c_all">0</span></button>
        <button class="btn btn-danger btn-sm" title="Hapus Semua" onclick="clearFilter('all')">Hapus</button>
      </div>
    </div>

    <!-- Saldo (auto-hide) -->
    <div class="sectionTitle">Saldo</div>
    <details>
      <summary>Saldo & Refresh</summary>
      <div class="content">
        <div class="card">
          <div id="balanceBox" class="mono small">—</div>
          <div style="margin-top:8px"><button class="btn btn-ghost btn-sm" onclick="fetchBalance()">Refresh</button></div>
        </div>
      </div>
    </details>

    <!-- Pengaturan Pembelian (auto-hide) -->
    <div class="sectionTitle">Pengaturan</div>
    <details>
      <summary>Beli Nomor</summary>
      <div class="content">
        <form id="buyForm" onsubmit="return buyNumber(event)">
          <input type="hidden" name="csrf" value="<?= htmlspecialchars($_SESSION['csrf']) ?>">
          <div class="card">
            <div class="row">
              <div class="col-12">
                <label>Country</label>
                <select name="country" id="country"></select>
              </div>
              <div class="col-12">
                <label>Service</label>
                <select name="service" id="service" disabled></select>
                <input id="serviceCustom" class="hidden" disabled>
              </div>
              <div class="col-12">
                <label>Operator</label>
                <select name="operator" id="operator">
                  <option value="any">Any</option>
                  <option value="telkomsel">telkomsel</option>
                  <option value="axis">axis</option>
                  <option value="three">three</option>
                </select>
                <div id="opStocks" class="muted mono small" style="margin-top:6px">Any: ? | telkomsel: ? | axis: ? | three: ?</div>
              </div>
              <div class="col-12">
                <label>Pieces</label>
                <input type="number" name="pieces" id="pieces" value="1" min="1" max="50">
                <div class="muted small" style="margin-top:6px">Maks 50 per klik</div>
              </div>
            </div>
            <div style="margin-top:10px"><button class="btn btn-primary btn-sm" type="submit">Beli</button></div>
          </div>
        </form>
      </div>
    </details>

    <!--<div class="sectionTitle">Info</div>-->
    <!--<div class="card"><div class="mono small" style="word-break:break-all">API: <?= htmlspecialchars($API_BASE) ?></div></div>-->
  </aside>

  <div class="overlay" id="overlay" onclick="toggleSidebar(false)"></div>

  <main class="main">
    <div class="topbar">
      <div style="display:flex;align-items:center;gap:8px">
        <button class="btn btn-sm hamburger" onclick="toggleSidebar(true)">☰</button>
        <h1 style="margin:0;font-size:16px">OTP Receiver — <span class="badge">SMS- VIRTUAL DIGITAL</span></h1>
      </div>
      <span class="muted small">ENV <span class="mono">SMSA_API_KEY</span> disarankan</span>
    </div>

    <div class="card">
      <div style="display:flex;justify-content:space-between;align-items:center;gap:8px;">
        <h3 style="margin:0;font-size:16px">Aktivasi</h3>
        <button class="btn btn-ghost btn-sm" title="Hapus item yang sedang ditampilkan" onclick="clearFilter(currentFilter)">Hapus yang ditampilkan</button>
      </div>

      <table class="table" id="actTable">
        <thead><tr><th>Nomor + Harga</th><th>Status</th><th>Action</th><th>Kode SMS</th></tr></thead>
        <tbody id="actTbody"><tr><td colspan="4" class="muted">Belum ada aktivasi.</td></tr></tbody>
      </table>
      <div id="actCards"></div>
    </div>
  </main>
</div>

<script>
const CSRF = <?= json_encode($_SESSION['csrf']) ?>;
const LSK = 'smsa_activations_v1';
let activations = []; // {id, number, service, country, operator, price, status, otp, canceled, createdAt}
let pollTimer=null;
let priceMap = {};     // { wa: <cost in $> }
let countryPhone = {}; // { countryId: "62" }
const DEFAULT_SERVICES = ['wa']; // hanya wa
let currentFilter = 'inprogress';

function $(id){return document.getElementById(id)}
function toggleSidebar(show){ const sb=$('sidebar'), ov=$('overlay'); if(show){sb.classList.add('open');ov.classList.add('show')} else {sb.classList.remove('open');ov.classList.remove('show')} }
function copyText(t){ if(!t||t==='—')return; navigator.clipboard.writeText(t.trim()).then(()=>toast('Disalin')).catch(()=>alert('Gagal menyalin')); }
function toast(msg){ const d=document.createElement('div'); d.textContent=msg; Object.assign(d.style,{position:'fixed',bottom:'16px',right:'16px',background:'#111',color:'#fff',padding:'8px 10px',borderRadius:'8px',opacity:'0.95',zIndex:'9999',fontSize:'.9rem'}); document.body.appendChild(d); setTimeout(()=>d.remove(),1300); }
async function fetchJSON(url,opts={}){ const r=await fetch(url,opts); const j=await r.json(); if(!j.ok) throw new Error(j.error||'error'); return j; }

// ---------- LocalStorage ----------
function saveLocal(){ try{ localStorage.setItem(LSK, JSON.stringify(activations)); }catch(e){} }
function loadLocal(){
  try{ const raw = localStorage.getItem(LSK); if(!raw) return; const arr = JSON.parse(raw); if(Array.isArray(arr)) activations = arr; }catch(e){}
}

// ---------- Sorting: newest first (descending) ----------
function sortActivationsDesc(){
  activations.sort((a,b) => (b.createdAt || 0) - (a.createdAt || 0));
}

// ---------- INIT ----------
loadLocal();
sortActivationsDesc();                 // TERBARU DI ATAS saat awal
updateCounts(); updateActivationsUI();
startPolling();                        // polling item yang sudah ada

fetchBalance();
initIndonesiaOnly().then(()=>initServiceWAOnly().then(updateOperatorStocks));

document.querySelectorAll('.sidebar .btn[data-filter]').forEach(b=>b.addEventListener('click',()=>setFilter(b.dataset.filter)));
['country','service','operator'].forEach(id=>{ const el=$(id); if(!el) return; el.addEventListener('change', async()=>{ await updateOperatorStocks(); }); });

// ---------- Saldo ----------
async function fetchBalance(){ try{ const j=await fetchJSON('?ajax=balance'); $('balanceBox').textContent=j.data.raw||'(no data)'; }catch(e){ $('balanceBox').textContent='Error: '+e.message; } }

// ---------- Country (Indonesia-only) ----------
async function initIndonesiaOnly(){
  const sel=$('country'); sel.innerHTML='<option value="0">Loading...</option>';
  try{
    const j=await fetchJSON('?ajax=countries'); sel.innerHTML='';
    const [code, obj] = Object.entries(j.data||{})[0] || ['6',{eng:'Indonesia'}];
    const o=document.createElement('option'); o.value=code; o.textContent=obj?.eng||'Indonesia'; sel.appendChild(o);
    const p = obj?.phoneCode || obj?.dialCode || obj?.prefix || '62';
    countryPhone[code] = String(p).replace(/^\+/, '');
    sel.value = code;
  }catch(e){
    sel.innerHTML=''; const o=document.createElement('option'); o.value='6'; o.textContent='Indonesia'; sel.appendChild(o); countryPhone['6']='62'; sel.value='6';
  }
}

// ---------- Service (WA-only) ----------
async function initServiceWAOnly(){
  const country = $('country').value || '0';
  const sel=$('service'); sel.innerHTML='<option>Loading…</option>'; priceMap = {};
  try{
    const j=await fetchJSON('?ajax=prices&country='+encodeURIComponent(country));
    let cost=null; const d=j.data||{};
    if (d.wa && typeof d.wa==='object' && d.wa.cost!=null) cost = d.wa.cost;
    if (!cost && d[country] && d[country].wa && d[country].wa.cost!=null) cost = d[country].wa.cost;
    priceMap.wa = cost;
    sel.innerHTML='';
    const opt=document.createElement('option'); opt.value='wa'; opt.textContent='wa'+(cost!=null?` ($ ${cost})`:``); sel.appendChild(opt); sel.value='wa';
  }catch(e){
    sel.innerHTML=''; const opt=document.createElement('option'); opt.value='wa'; opt.textContent='wa'; sel.appendChild(opt); sel.value='wa';
  }
}

// ---------- Operator Stocks ----------
async function updateOperatorStocks(){
  const c=$('country').value || '0'; const svc='wa';
  try{
    const j=await fetchJSON('?ajax=operator_stock&country='+encodeURIComponent(c)+'&service='+encodeURIComponent(svc));
    const d=j.data||{};
    $('opStocks').textContent = `Any: ${fmtCount(d.any)} | telkomsel: ${fmtCount(d.telkomsel)} | axis: ${fmtCount(d.axis)} | three: ${fmtCount(d.three)}`;
    const optSel=$('operator');
    [...optSel.options].forEach(o=>{
      const key=o.value.toLowerCase(); const cnt = (key==='any')?d.any:d[key];
      const cap = key.charAt(0).toUpperCase()+key.slice(1);
      o.textContent = `${cap} ${cnt!=null?`(stok: ${cnt})`:'(stok: ?)'}`;
    });
  }catch(e){ $('opStocks').textContent='Any: ? | telkomsel: ? | axis: ? | three: ?'; }
}
function fmtCount(v){ return (v==null?'?':v); }

// ---------- Beli Nomor ----------
function buyNumber(ev){
  ev.preventDefault();
  const fd=new FormData($('buyForm')); fd.append('csrf', CSRF);
  fd.set('service','wa'); // force wa
  const svc='wa'; const country=fd.get('country'); const operator=fd.get('operator');
  const pieces = Math.max(1, Math.min(50, parseInt(fd.get('pieces')||'1',10)));
  const price = priceMap[svc]!=null? priceMap[svc] : null;

  fetch('?ajax=buy_number',{method:'POST',body:fd})
    .then(r=>r.json())
    .then(async j=>{
      if(!j.ok) throw new Error(j.error||'gagal beli');
      const items = j.items||[];
      for(const it of items){
        activations.push({ // tambahkan lalu sort desc → terbaru di atas
          id: it.id, number: it.number, service: svc, country, operator,
          price, status: 'STATUS_WAIT_CODE', otp: null, canceled: false, createdAt: Date.now()
        });
      }
      sortActivationsDesc();
      updateCounts(); updateActivationsUI(); saveLocal();
      await updateOperatorStocks();
      toast(`Berhasil beli ${items.length} nomor`);
    })
    .catch(e=>alert('Error: '+e.message));
  return false;
}

// ---------- Kategorisasi & Filter ----------
function stateOf(a){
  if (a.canceled) return 'cancelled';
  const tag = String(a.status||'').toUpperCase();
  if (a.otp || tag.includes('STATUS_OK') || tag.includes('STATUS_FINISH') || tag.includes('STATUS_COMPLETE')) return 'completed';
  return 'inprogress';
}
function setFilter(f){
  currentFilter = f;
  document.querySelectorAll('.sidebar .btn[data-filter]').forEach(b=>b.classList.toggle('btn-primary', b.dataset.filter===f));
  updateActivationsUI();
  toggleSidebar(false);
}
function filteredActivations(){
  let list = activations.slice();
  if (currentFilter!=='all') list = list.filter(a=>stateOf(a)===currentFilter);
  if (currentFilter==='inprogress') list = list.filter(a=>!a.canceled); // semua aktif
  // TERBARU DI ATAS
  list.sort((a,b)=> (b.createdAt||0) - (a.createdAt||0));
  return list;
}
function updateCounts(){
  const c_all = activations.length;
  const c_in = activations.filter(a=>stateOf(a)==='inprogress').length;
  const c_done = activations.filter(a=>stateOf(a)==='completed').length;
  const c_can = activations.filter(a=>stateOf(a)==='cancelled').length;
  $('c_all').textContent = c_all; $('c_inprogress').textContent = c_in; $('c_completed').textContent = c_done; $('c_cancelled').textContent = c_can;
}

// ---------- HAPUS per filter ----------
function clearFilter(filter){
  let msg = 'Hapus semua item ';
  if (filter==='all') msg += 'di semua filter? Tindakan ini tidak dapat dibatalkan dan tidak membatalkan aktivasi di server.';
  else if (filter==='inprogress') msg += 'In Progress? Item akan dihapus dari daftar lokal (tidak membatalkan di server).';
  else if (filter==='completed') msg += 'Completed?';
  else if (filter==='cancelled') msg += 'Cancelled?';
  else msg += 'untuk filter saat ini?';

  if (!confirm(msg)) return;

  if (filter==='all') {
    activations = [];
  } else {
    activations = activations.filter(a => stateOf(a) !== filter);
  }

  sortActivationsDesc();
  saveLocal();
  updateCounts();
  updateActivationsUI();
  toast('Daftar berhasil dibersihkan');
}

// ---------- Render ----------
function localizeNumber(e164, countryId){
  if(!e164) return '';
  let n = String(e164).replace(/[^\d+]/g,'');
  n = n.replace(/^\+/, '');
  const code = countryPhone[countryId];
  if(code && n.startsWith(code)) n = n.slice(code.length);
  return n;
}
function renderRow(a){
  const tr = document.createElement('tr');
  const local = localizeNumber(a.number, a.country);
  const td1 = document.createElement('td');
  td1.innerHTML = `<div class="mono">${a.number}</div>
                   <div class="cellActions" style="margin-top:6px">
                     <button class="btn btn-sm copybtn" onclick="copyText('${local}')">Copy Lokal</button>
                     <span class="muted small">Harga: ${a.price!=null?('$ '+a.price):'?'}</span>
                   </div>`;
  const td2 = document.createElement('td'); td2.innerHTML = `<span class="mono small">${a.status||'—'}</span>`;
  const td3 = document.createElement('td');
  const b = document.createElement('button'); b.className='btn btn-danger btn-sm'; b.textContent='Batal'; b.onclick = ()=> cancelActivation(a.id);
  td3.appendChild(b);
  const td4 = document.createElement('td');
  const code = a.otp? a.otp : '—';
  td4.innerHTML = `<div class="mono">${code}</div>
                   <div style="margin-top:6px"><button class="btn btn-sm copybtn" ${a.otp?'':'disabled'} onclick="copyText('${a.otp||''}')">Copy SMS</button></div>`;
  tr.appendChild(td1); tr.appendChild(td2); tr.appendChild(td3); tr.appendChild(td4);
  return tr;
}
function renderCard(a){
  const div = document.createElement('div'); div.className='cardItem';
  const local = localizeNumber(a.number, a.country);
  div.innerHTML = `
    <div style="display:flex;justify-content:space-between;gap:10px;align-items:center">
      <div class="mono" style="word-break:break-all">${a.number}</div>
      <button class="btn btn-danger btn-sm" onclick="cancelActivation('${a.id}')">Batal</button>
    </div>
    <div class="muted small" style="margin-top:6px">Harga: ${a.price!=null?('$ '+a.price):'?'}</div>
    <div style="margin-top:6px"><button class="btn btn-sm copybtn" onclick="copyText('${local}')">Copy Lokal</button></div>
    <div style="margin-top:6px">Status: <span class="mono small">${a.status||'—'}</span></div>
    <div style="margin-top:6px">Kode SMS: <span class="mono">${a.otp||'—'}</span></div>
    <div style="margin-top:6px"><button class="btn btn-sm copybtn" ${a.otp?'':'disabled'} onclick="copyText('${a.otp||''}')">Copy SMS</button></div>
  `;
  return div;
}
function updateActivationsUI(){
  const tb = $('actTbody'); const cards = $('actCards');
  tb.innerHTML = ''; cards.innerHTML='';
  const list = filteredActivations();
  if(list.length===0){
    tb.innerHTML='<tr><td colspan="4" class="muted">Tidak ada item untuk filter ini.</td></tr>';
  } else {
    for(const a of list){ tb.appendChild(renderRow(a)); cards.appendChild(renderCard(a)); }
  }
  updateCounts(); saveLocal();
}

// ---------- Polling ----------
function startPolling(){
  stopPolling();
  pollTimer=setInterval(async ()=>{
    const list = activations.filter(x=>!x.canceled);
    if(list.length===0) return;
    for(const a of list){
      try{
        const j=await fetchJSON('?ajax=status&id='+encodeURIComponent(a.id));
        const beforeState = stateOf(a);
        a.status = j.raw || a.status;
        if (j.otp) a.otp = j.otp;
        const afterState = stateOf(a);
        if (beforeState!==afterState) updateCounts();
      }catch(e){}
    }
    // jaga urutan tetap terbaru di atas (kalau ada createdAt yang berubah—jarang, tapi aman)
    sortActivationsDesc();
    updateActivationsUI();
  }, 5000);
}
function stopPolling(){ if(pollTimer) clearInterval(pollTimer); pollTimer=null; }

// ---------- setStatus (batal) ----------
function cancelActivation(id){
  const fd=new FormData(); fd.append('csrf',CSRF); fd.append('id',id); fd.append('status','8');
  fetch('?ajax=set_status',{method:'POST',body:fd})
    .then(r=>r.json())
    .then(j=>{
      if(!j.ok) throw new Error(j.error||'gagal set status');
      const a = activations.find(x=>x.id===id); if(a){ a.canceled=true; }
      toast('Aktivasi dibatalkan');
      updateCounts(); updateActivationsUI(); saveLocal();
    })
    .catch(e=>alert('Error: '+e.message));
}
</script>
</body>
</html>
