<?php
declare(strict_types=1);
session_start();

$API_KEY  = '218149U3eccfd06b0a88f841850256271d7c3c0';
$API_BASE = 'https://smshub.org/stubs/handler_api.php';

if (empty($_SESSION['csrf'])) $_SESSION['csrf'] = bin2hex(random_bytes(16));

function check_csrf(): void {
  if ($_SERVER['REQUEST_METHOD']==='POST') {
    $ok = isset($_POST['csrf']) && hash_equals($_SESSION['csrf']??'', $_POST['csrf']);
    if (!$ok) { http_response_code(400); echo json_encode(['ok'=>false,'error'=>'Invalid CSRF']); exit; }
  }
}

function sh_call(array $params): array {
  global $API_KEY, $API_BASE;
  $params = array_merge(['api_key'=>$API_KEY], $params);
  $url = $API_BASE.'?'.http_build_query($params);
  $ch = curl_init();
  curl_setopt_array($ch, [
    CURLOPT_URL=>$url, CURLOPT_RETURNTRANSFER=>true,
    CURLOPT_TIMEOUT=>20, CURLOPT_SSL_VERIFYPEER=>false, CURLOPT_SSL_VERIFYHOST=>0
  ]);
  $res = curl_exec($ch); $err = curl_error($ch); curl_close($ch);
  if ($err) return ['ok'=>false,'error'=>$err];
  return ['ok'=>true,'raw'=>$res];
}

function parse_handler_text(string $raw): array {
  $parts = explode(':', trim($raw));
  return ['raw'=>$raw,'tag'=>$parts[0]??null,'parts'=>$parts];
}

if (isset($_GET['ajax'])) {
  $action = $_GET['ajax'];
  if ($_SERVER['REQUEST_METHOD']==='POST') check_csrf();

  switch ($action) {
    case 'balance': {
      $r=sh_call(['action'=>'getBalance']);
      echo json_encode(['ok'=>true,'data'=>parse_handler_text($r['raw'])]); exit;
    }
    case 'operator_stock': {
      $r=sh_call(['action'=>'getNumbersStatus','country'=>'6','json'=>1]);
      $j=json_decode($r['raw'],true);
      $ops=['any','telkomsel','axis','three']; $out=[];
      foreach($ops as $op) $out[$op]=$j["wa_".$op]??null;
      echo json_encode(['ok'=>true,'data'=>$out]); exit;
    }
    case 'buy_number': {
      $operator=$_POST['operator']??'any';
      $pcs=max(1,min(50,(int)($_POST['pieces']??1)));
      $items=[]; $errors=[];
      for($i=0;$i<$pcs;$i++){
        $r=sh_call(['action'=>'getNumber','service'=>'wa','country'=>'6','operator'=>$operator]);
        $p=parse_handler_text($r['raw']);
        // Format SMSHub: ACCESS_NUMBER:id:number
        if(($p['tag']??'')==='ACCESS_NUMBER' && count($p['parts'])>=3){
          $items[]=[
            'id'=>$p['parts'][1],
            'number'=>$p['parts'][2],
            'price'=>$p['parts'][3]??null
          ];
        } else { $errors[]=$r['raw']; }
      }
      if(empty($items)) echo json_encode(['ok'=>false,'error'=>'Gagal beli nomor: '.implode(' | ',$errors)]);
      else echo json_encode(['ok'=>true,'items'=>$items,'errors'=>$errors]);
      exit;
    }
    case 'status': {
      $id=$_GET['id'];
      $r=sh_call(['action'=>'getStatus','id'=>$id]);
      $otp=null; if(preg_match('/\b(\d{4,8})\b/',$r['raw'],$m)) $otp=$m[1];
      echo json_encode(['ok'=>true,'raw'=>$r['raw'],'otp'=>$otp]); exit;
    }
    case 'set_status': {
      $id=$_POST['id'];
      $r=sh_call(['action'=>'setStatus','id'=>$id,'status'=>'8']);
      echo json_encode(['ok'=>true,'raw'=>$r['raw']]); exit;
    }
  }
}
?>
<!doctype html>
<html lang="id">
<head>
<meta charset="utf-8">
<title>VIRTUAL DIGITAL OTP</title>
<meta name="viewport" content="width=device-width, initial-scale=1">
<style>
:root{
  --bg:#0f1113; --card:#1a1f24; --text:#eaeef5; --muted:#8c98a5;
  --primary:#2563eb; --danger:#b91c1c; --radius:14px; --pad:12px;
}
*{box-sizing:border-box;font-family:system-ui}
body{margin:0;background:var(--bg);color:var(--text);}
.app{display:flex;min-height:100vh}
.sidebar{width:280px;background:#12171d;padding:var(--pad);border-right:1px solid #222;position:fixed;top:0;left:-300px;transition:left .25s;height:100vh;overflow-y:auto;z-index:1000}
.sidebar.open{left:0}
.overlay{position:fixed;inset:0;background:rgba(0,0,0,.4);display:none;z-index:999}
.overlay.show{display:block}
.main{flex:1;padding:var(--pad);margin-left:0}
.topbar{display:flex;justify-content:space-between;align-items:center;margin-bottom:12px}
.hamburger{background:var(--primary);border:none;padding:6px 10px;border-radius:8px;color:#fff;font-size:18px}
.card{background:var(--card);padding:var(--pad);border-radius:var(--radius);margin-bottom:12px}
.btn{padding:6px 10px;border:none;border-radius:8px;cursor:pointer;font-size:14px}
.btn-primary{background:var(--primary);color:#fff}
.btn-danger{background:var(--danger);color:#fff}
.btn-ghost{background:#2a3138;color:var(--text)}
.btn.active{background:var(--primary);color:#fff}
.cardItem{background:var(--card);padding:var(--pad);border-radius:var(--radius);margin-bottom:10px}
.toast{position:fixed;bottom:20px;right:20px;background:#222;color:#fff;padding:10px 14px;border-radius:10px;opacity:.95;z-index:2000;animation:fadeIn .3s ease}
@keyframes fadeIn{from{opacity:0;transform:translateY(10px)}to{opacity:.95;transform:translateY(0)}}
.filterRow{display:flex;gap:6px;margin:4px 0;flex-wrap:wrap}
.badge{background:var(--primary);padding:2px 6px;border-radius:10px;font-size:12px}
</style>
</head>
<body>
<div class="app">
  <aside id="sidebar" class="sidebar">
    <h3>VIRTUAL DIGITAL OTP</h3>
    <button class="btn btn-ghost" onclick="fetchBalance()">Refresh Saldo</button>
    <div id="balanceBox" style="margin:10px 0">Saldo: —</div>

    <div class="card">
      <h4>Beli Nomor</h4>
      <form id="buyForm" onsubmit="return buyNumber(event)">
        <input type="hidden" name="csrf" value="<?= htmlspecialchars($_SESSION['csrf']) ?>">
        <label>Operator</label>
        <select name="operator" id="operator">
          <option value="any">Any</option><option value="telkomsel">Telkomsel</option>
          <option value="axis">Axis</option><option value="three">Three</option>
        </select>
        <div id="opStocks" style="font-size:13px;color:var(--muted);margin:6px 0">Any: ? | Telkomsel: ? | Axis: ? | Three: ?</div>
        <label>Jumlah (pcs)</label>
        <input type="number" name="pieces" value="1" min="1" max="50" style="width:100%;padding:6px">
        <button type="submit" class="btn btn-primary" style="width:100%;margin-top:8px">Beli Nomor WA</button>
        <div id="errorBox" style="color:#f87171;font-size:13px;margin-top:6px"></div>
      </form>
    </div>

    <div class="card">
      <h4>Filter Aktivasi</h4>
      <div class="filterRow">
        <button id="f_all" class="btn btn-ghost" onclick="setFilter('all')">All <span class="badge" id="c_all">0</span></button>
        <button id="f_inprogress" class="btn btn-ghost" onclick="setFilter('inprogress')">In Progress <span class="badge" id="c_inprogress">0</span></button>
      </div>
      <div class="filterRow">
        <button id="f_completed" class="btn btn-ghost" onclick="setFilter('completed')">Completed <span class="badge" id="c_completed">0</span></button>
        <button id="f_cancelled" class="btn btn-ghost" onclick="setFilter('cancelled')">Cancelled <span class="badge" id="c_cancelled">0</span></button>
      </div>
    </div>
  </aside>

  <div class="overlay" id="overlay" onclick="toggleSidebar(false)"></div>

  <main class="main">
    <div class="topbar">
      <button class="hamburger" onclick="toggleSidebar(true)">☰</button>
      <!--<h2>Aktivasi</h2>-->
    </div>
    <div id="actCards"></div>
  </main>
</div>

<script>
let activations=JSON.parse(localStorage.getItem("sms_acts")||"[]");
let pollTimer=null;
let currentFilter='all';

function toggleSidebar(show){document.getElementById("sidebar").classList.toggle("open",show);document.getElementById("overlay").classList.toggle("show",show);}
function toast(msg){let d=document.createElement("div");d.className="toast";d.textContent=msg;document.body.appendChild(d);setTimeout(()=>d.remove(),2000);}
function saveLocal(){localStorage.setItem("sms_acts",JSON.stringify(activations));}

function fetchBalance(){fetch("?ajax=balance").then(r=>r.json()).then(j=>{document.getElementById("balanceBox").textContent="Saldo: "+(j.data.raw||"-");})}
function updateOperatorStocks(){fetch("?ajax=operator_stock").then(r=>r.json()).then(j=>{let d=j.data;document.getElementById("opStocks").textContent=`Any: ${d.any??'?'} | Telkomsel: ${d.telkomsel??'?'} | Axis: ${d.axis??'?'} | Three: ${d.three??'?'}`;});}

function localNumber(num){ return num.startsWith("62") ? num.slice(2) : num; }

function buyNumber(ev){
  ev.preventDefault(); let fd=new FormData(document.getElementById("buyForm"));
  document.getElementById("errorBox").textContent="";
  fetch("?ajax=buy_number",{method:"POST",body:fd}).then(r=>r.json()).then(j=>{
    if(!j.ok){ document.getElementById("errorBox").textContent=j.error; return; }
    j.items.forEach(it=>activations.push({id:it.id,number:it.number,status:"WAIT",otp:null,price:it.price||null,canceled:false,createdAt:Date.now()}));
    saveLocal(); updateUI(); startPolling(); updateOperatorStocks(); toast("Berhasil beli "+j.items.length+" nomor");
  });
  return false;
}

function stateOf(a){
  if(a.canceled || (a.status && a.status.includes("CANCEL"))) return 'cancelled';
  if(a.otp) return 'completed';
  return 'inprogress';
}

function setFilter(f){
  currentFilter=f;
  document.querySelectorAll('.card button').forEach(btn=>btn.classList.remove('active'));
  let el=document.getElementById('f_'+f); if(el) el.classList.add('active');
  updateUI();
}

function updateCounts(){
  document.getElementById("c_all").textContent=activations.length;
  document.getElementById("c_inprogress").textContent=activations.filter(a=>stateOf(a)==='inprogress').length;
  document.getElementById("c_completed").textContent=activations.filter(a=>stateOf(a)==='completed').length;
  document.getElementById("c_cancelled").textContent=activations.filter(a=>stateOf(a)==='cancelled').length;
}

function updateUI(){
  let cards=document.getElementById("actCards");
  cards.innerHTML="";
  let list=activations.slice().sort((a,b)=>b.createdAt-a.createdAt);
  if(currentFilter!=='all'){list=list.filter(a=>stateOf(a)===currentFilter);}
  if(!list.length){cards.innerHTML="<div class='cardItem'>Tidak ada data</div>";}
  list.forEach(a=>{
    let nomor=localNumber(a.number);
    let div=document.createElement("div");div.className="cardItem";
    div.innerHTML=`<div><b>${nomor}</b></div>
      <div>Status: ${a.status}</div>
      <div>Harga: ${a.price?('$'+a.price):'?'}</div>
      <div>OTP: <b>${a.otp||"-"}</b></div>
      <div style="margin-top:6px;display:flex;gap:6px;flex-wrap:wrap">
        <button class="btn btn-ghost" onclick="copy('${nomor}')">Copy Nomor</button>
        <button class="btn btn-primary" ${a.otp?'':'disabled'} onclick="copy('${a.otp||''}')">Copy OTP</button>
        <button class="btn btn-danger" onclick="cancelActivation('${a.id}')">Batal</button>
      </div>`;
    cards.appendChild(div);
  });
  updateCounts();
  saveLocal();
}

function copy(t){if(!t)return;navigator.clipboard.writeText(t);toast("Disalin: "+t);}
function startPolling(){if(pollTimer)clearInterval(pollTimer);pollTimer=setInterval(pollStatus,5000);}
function pollStatus(){activations.forEach(async a=>{if(a.canceled)return;let r=await fetch("?ajax=status&id="+a.id);let j=await r.json();if(j.ok){a.status=j.raw;if(j.otp)a.otp=j.otp;saveLocal();updateUI();}});}
function cancelActivation(id){let fd=new FormData();fd.append("id",id);fd.append("csrf","<?= $_SESSION['csrf'] ?>");fetch("?ajax=set_status",{method:"POST",body:fd}).then(()=>{let a=activations.find(x=>x.id===id);if(a)a.canceled=true;saveLocal();updateUI();toast("Aktivasi dibatalkan");});}

updateUI();startPolling();updateOperatorStocks();fetchBalance();setFilter('all');
</script>
</body>
</html>
