
import { Kline } from '../types';

const PROXY = 'https://api.allorigins.win/raw?url=';
const BASE = 'https://open-api.bingx.com/openApi/swap';

export async function fetchTickers() {
  const res = await fetch(`${BASE}/v2/quote/ticker`);
  const json = await res.json();
  return json.data || [];
}

export async function fetchKlines(symbol: string, interval: string = '1h'): Promise<Kline[]> {
  const res = await fetch(`${BASE}/v3/quote/klines?symbol=${symbol}&interval=${interval}&limit=100`);
  const json = await res.json();
  if (!json.data) return [];
  return json.data.map((k: any) => ({
    time: k.time,
    open: parseFloat(k.open),
    high: parseFloat(k.high),
    low: parseFloat(k.low),
    close: parseFloat(k.close),
    volume: parseFloat(k.volume)
  })).reverse();
}
