
import { GoogleGenAI } from "@google/genai";
import { MarketItem } from "../types";

const ai = new GoogleGenAI({ apiKey: process.env.API_KEY });

export async function getSniperVerdict(item: MarketItem) {
  try {
    const prompt = `Analisis aset ${item.symbol}. 
    Harga: ${item.price}, Skor Algo: ${item.algoScore}/100, RSI: ${item.rsi.toFixed(2)}. 
    Trend 1H: ${item.mtf.h1.trend}, Trend 4H: ${item.mtf.h4.trend}. 
    Wick Atas: ${item.wick.upperPct.toFixed(2)}%.
    Berikan 1 kalimat kesimpulan teknis profesional (Sniper Verdict) dan 1 kalimat strategi manajemen risiko.`;

    const response = await ai.models.generateContent({
      model: 'gemini-3-flash-preview',
      contents: prompt,
    });
    return response.text;
  } catch (e) {
    return "Analisis AI tidak tersedia saat ini. Gunakan indikator teknis.";
  }
}
