
export interface Kline {
  open: number;
  high: number;
  low: number;
  close: number;
  volume: number;
  time: number;
}

export interface WickMetrics {
  upperPct: number;
  lowerPct: number;
  isStrongRejection: boolean;
}

export interface SupportResistance {
  nearestRes: number | null;
  nearestSup: number | null;
  proximityRes: number;
  proximitySup: number;
}

export interface TimeframeAnalysis {
  rsi: number;
  trend: 'bull' | 'bear' | 'side';
}

export interface MarketItem {
  symbol: string;
  price: number;
  prevPrice: number;
  change24h: number;
  volume24h: number;
  rsi: number;
  wick: WickMetrics;
  sr: SupportResistance;
  mtf: {
    m15: TimeframeAnalysis;
    h1: TimeframeAnalysis;
    h4: TimeframeAnalysis;
  };
  algoScore: number;
  lastUpdate: number;
}

export enum FilterMode {
  ALL = 'all',
  CONFLUENCE = 'confluence',
  HIGH_SCORE = 'high_score',
  FAVORITES = 'favorites'
}

export enum SortMode {
  ALGO_SCORE = 'algo',
  VOLATILITY = 'volatility',
  VOLUME = 'volume'
}
